(*
  Created by Swagger2Delphi v1.3 2023-03-04 16:38:54
*)

unit petstore;

interface

uses
  System.JSON;

type

  TApiResponse = class
  private
    Fcode : integer;
    Ftype : string;
    Fmessage : string;
  public
    property code : integer read Fcode write Fcode;
    property &type : string read Ftype write Ftype;
    property &message : string read Fmessage write Fmessage;
  end;

  TTag = class
  private
    Fid : int64;
    Fname : string;
  public
    property id : int64 read Fid write Fid;
    property &name : string read Fname write Fname;
  end;

  TCategory = class
  private
    Fid : int64;
    Fname : string;
  public
    property id : int64 read Fid write Fid;
    property &name : string read Fname write Fname;
  end;

  TPet = class
  private
    Fid : int64;
    Fcategory : TCategory;
    Fname : string;
    FphotoUrls : TArray<string>;
    Ftags : TArray<TTag>;
    // pet status in the store
    Fstatus : string;
  public
    destructor Destroy; override;
    property id : int64 read Fid write Fid;
    property category : TCategory read Fcategory write Fcategory;
    property &name : string read Fname write Fname;
    property photoUrls : TArray<string> read FphotoUrls write FphotoUrls;
    property tags : TArray<TTag> read Ftags write Ftags;
    property status : string read Fstatus write Fstatus;
  end;

  TOrder = class
  private
    Fid : int64;
    FpetId : int64;
    Fquantity : integer;
    FshipDate : TDateTime;
    // Order Status
    Fstatus : string;
    Fcomplete : boolean;
  public
    property id : int64 read Fid write Fid;
    property petId : int64 read FpetId write FpetId;
    property quantity : integer read Fquantity write Fquantity;
    property shipDate : TDateTime read FshipDate write FshipDate;
    property status : string read Fstatus write Fstatus;
    property complete : boolean read Fcomplete write Fcomplete;
  end;

  TUser = class
  private
    Fid : int64;
    Fusername : string;
    FfirstName : string;
    FlastName : string;
    Femail : string;
    Fpassword : string;
    Fphone : string;
    // User Status
    FuserStatus : integer;
  public
    property id : int64 read Fid write Fid;
    property username : string read Fusername write Fusername;
    property firstName : string read FfirstName write FfirstName;
    property lastName : string read FlastName write FlastName;
    property email : string read Femail write Femail;
    property password : string read Fpassword write Fpassword;
    property phone : string read Fphone write Fphone;
    property userStatus : integer read FuserStatus write FuserStatus;
  end;

  Tv2 = class
  private
    FAuthorization : string;
  public
    property Authorization : string read FAuthorization write FAuthorization;
    function uploadFile(petId : int64; additionalMetadata : string; &file : string) : TApiResponse;
    procedure updatePet(body : TPet);
    procedure addPet(body : TPet);
    function findPetsByStatus(status : TArray<string>) : TArray<TPet>;
    function findPetsByTags(tags : TArray<string>) : TArray<TPet>;
    function getPetById(petId : int64) : TPet;
    procedure updatePetWithForm(petId : int64; &name : string; status : string);
    procedure deletePet(api_key : string; petId : int64);
    function placeOrder(body : TOrder) : TOrder;
    function getOrderById(orderId : int64) : TOrder;
    procedure deleteOrder(orderId : int64);
    function getInventory : TJSONValue;
    procedure createUsersWithArrayInput(body : TArray<TUser>);
    procedure createUsersWithListInput(body : TArray<TUser>);
    function getUserByName(username : string) : TUser;
    procedure updateUser(username : string; body : TUser);
    procedure deleteUser(username : string);
    function loginUser(username : string; password : string) : string;
    procedure logoutUser;
    procedure createUser(body : TUser);
  end;

implementation

uses
  REST.Types,
  REST.JSON,
  REST.Client,
  SOAP.XSBuiltins,
  System.Generics.Collections,
  System.SysUtils,
  System.DateUtils;

{ TPet }

destructor TPet.Destroy;
var
  T : TObject;
begin
  if Assigned(Fcategory) then
    Fcategory.Free;
  for T in Ftags do
    T.Free;
  inherited;
end;

function Tv2.uploadFile(petId : int64; additionalMetadata : string; &file : string) : TApiResponse;
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Result           := nil;
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmPOST;
    Request.Accept := 'application/json';
    Request.Resource := '/pet/{petId}/uploadImage';
    // Security (oauth2) petstore_auth:  in 
    // OAuth2 implicit https://petstore.swagger.io/oauth/authorize
    Request.AddParameter('petId', IntToStr(petId), pkURLSEGMENT, []);
    if additionalMetadata <> emptyStr then
    begin
      Request.AddParameter('additionalMetadata', additionalMetadata, pkREQUESTBODY, []);
    end;
    if &file <> emptyStr then
    begin
      Request.AddParameter('file', &file, pkREQUESTBODY, []);
    end;
    Request.Execute;
    if Response.StatusCode = 200 then
    begin
      Result := TJSON.JSONToObject<TApiResponse>(Response.Content);
    end;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.updatePet(body : TPet);
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmPUT;
    Request.Accept := 'application/json';
    Request.Resource := '/pet';
    Request.AddBody(TJSON.ObjectToJsonObject(body));
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.addPet(body : TPet);
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmPOST;
    Request.Accept := 'application/json';
    Request.Resource := '/pet';
    // Security (oauth2) petstore_auth:  in 
    // OAuth2 implicit https://petstore.swagger.io/oauth/authorize
    Request.AddBody(TJSON.ObjectToJsonObject(body));
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

function Tv2.findPetsByStatus(status : TArray<string>) : TArray<TPet>;
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
  LstatusItem : string;
  I          : Integer;
  ReturnArray: TJSONArray;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmGET;
    Request.Accept := 'application/json';
    Request.Resource := '/pet/findByStatus';
    // Security (oauth2) petstore_auth:  in 
    // OAuth2 implicit https://petstore.swagger.io/oauth/authorize
    for LstatusItem in status do
      Request.AddParameter('status', LstatusItem, pkQUERY, [poDoNotEncode]);
    Request.Execute;
    if Response.StatusCode = 200 then
    begin
      ReturnArray := TJSONArray(TJSONObject.ParseJSONValue(Response.Content));
      SetLength(Result, ReturnArray.Count);
      for I := 0 to ReturnArray.Count -1 do
      begin
        Result[I] := TJSON.JsonToObject<TPet>(TJSONObject(ReturnArray.Items[I]));
      end;
    end;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

function Tv2.findPetsByTags(tags : TArray<string>) : TArray<TPet>;
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
  LtagsItem : string;
  I          : Integer;
  ReturnArray: TJSONArray;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmGET;
    Request.Accept := 'application/json';
    Request.Resource := '/pet/findByTags';
    // Security (oauth2) petstore_auth:  in 
    // OAuth2 implicit https://petstore.swagger.io/oauth/authorize
    for LtagsItem in tags do
      Request.AddParameter('tags', LtagsItem, pkQUERY, [poDoNotEncode]);
    Request.Execute;
    if Response.StatusCode = 200 then
    begin
      ReturnArray := TJSONArray(TJSONObject.ParseJSONValue(Response.Content));
      SetLength(Result, ReturnArray.Count);
      for I := 0 to ReturnArray.Count -1 do
      begin
        Result[I] := TJSON.JsonToObject<TPet>(TJSONObject(ReturnArray.Items[I]));
      end;
    end;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

function Tv2.getPetById(petId : int64) : TPet;
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Result           := nil;
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmGET;
    Request.Accept := 'application/json';
    Request.Resource := '/pet/{petId}';
    if FAuthorization <> '' then
      Request.AddParameter('api_key', FAuthorization , pkHTTPHEADER, [poDoNotEncode]);
    Request.AddParameter('petId', IntToStr(petId), pkURLSEGMENT, []);
    Request.Execute;
    if Response.StatusCode = 200 then
    begin
      Result := TJSON.JSONToObject<TPet>(Response.Content);
    end;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.updatePetWithForm(petId : int64; &name : string; status : string);
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmPOST;
    Request.Accept := 'application/json';
    Request.Resource := '/pet/{petId}';
    Request.AddParameter('petId', IntToStr(petId), pkURLSEGMENT, []);
    if &name <> emptyStr then
    begin
      Request.Params.AddItem('name', &name, pkGETorPOST, [], TRESTContentType.ctAPPLICATION_X_WWW_FORM_URLENCODED);
    end;
    if status <> emptyStr then
    begin
      Request.Params.AddItem('status', status, pkGETorPOST, [], TRESTContentType.ctAPPLICATION_X_WWW_FORM_URLENCODED);
    end;
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.deletePet(api_key : string; petId : int64);
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmDelete;
    Request.Accept := 'application/json';
    Request.Resource := '/pet/{petId}';
    if api_key <> emptyStr then
    begin
      Request.AddParameter('api_key', api_key, pkHTTPHEADER, [poDoNotEncode]);
    end;
    Request.AddParameter('petId', IntToStr(petId), pkURLSEGMENT, []);
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

function Tv2.placeOrder(body : TOrder) : TOrder;
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Result           := nil;
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmPOST;
    Request.Accept := 'application/json';
    Request.Resource := '/store/order';
    Request.AddBody(TJSON.ObjectToJsonObject(body));
    Request.Execute;
    if Response.StatusCode = 200 then
    begin
      Result := TJSON.JSONToObject<TOrder>(Response.Content);
    end;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

function Tv2.getOrderById(orderId : int64) : TOrder;
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Result           := nil;
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmGET;
    Request.Accept := 'application/json';
    Request.Resource := '/store/order/{orderId}';
    Request.AddParameter('orderId', IntToStr(orderId), pkURLSEGMENT, []);
    Request.Execute;
    if Response.StatusCode = 200 then
    begin
      Result := TJSON.JSONToObject<TOrder>(Response.Content);
    end;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.deleteOrder(orderId : int64);
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmDelete;
    Request.Accept := 'application/json';
    Request.Resource := '/store/order/{orderId}';
    Request.AddParameter('orderId', IntToStr(orderId), pkURLSEGMENT, []);
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

function Tv2.getInventory : TJSONValue;
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Result           := nil;
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmGET;
    Request.Accept := 'application/json';
    Request.Resource := '/store/inventory';
    if FAuthorization <> '' then
      Request.AddParameter('api_key', FAuthorization , pkHTTPHEADER, [poDoNotEncode]);
    Request.Execute;
    if Response.StatusCode = 200 then
    begin
      Result := TJSONObject.ParseJSONValue(Response.Content);
    end;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.createUsersWithArrayInput(body : TArray<TUser>);
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
  LbodyItem : TUser;
  LbodyItemArray : TJSONArray;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  LbodyItemArray := TJSONArray.Create;
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmPOST;
    Request.Accept := 'application/json';
    Request.Resource := '/user/createWithArray';
    for LbodyItem in body do
      LbodyItemArray.AddElement(TJSON.ObjectToJSONObject(LbodyItem));
    Request.AddBody(LbodyItemArray.ToJSON, ctAPPLICATION_JSON);
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.createUsersWithListInput(body : TArray<TUser>);
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
  LbodyItem : TUser;
  LbodyItemArray : TJSONArray;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  LbodyItemArray := TJSONArray.Create;
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmPOST;
    Request.Accept := 'application/json';
    Request.Resource := '/user/createWithList';
    for LbodyItem in body do
      LbodyItemArray.AddElement(TJSON.ObjectToJSONObject(LbodyItem));
    Request.AddBody(LbodyItemArray.ToJSON, ctAPPLICATION_JSON);
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

function Tv2.getUserByName(username : string) : TUser;
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Result           := nil;
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmGET;
    Request.Accept := 'application/json';
    Request.Resource := '/user/{username}';
    Request.AddParameter('username', username, pkURLSEGMENT, []);
    Request.Execute;
    if Response.StatusCode = 200 then
    begin
      Result := TJSON.JSONToObject<TUser>(Response.Content);
    end;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.updateUser(username : string; body : TUser);
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmPUT;
    Request.Accept := 'application/json';
    Request.Resource := '/user/{username}';
    Request.AddParameter('username', username, pkURLSEGMENT, []);
    Request.AddBody(TJSON.ObjectToJsonObject(body));
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.deleteUser(username : string);
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmDelete;
    Request.Accept := 'application/json';
    Request.Resource := '/user/{username}';
    Request.AddParameter('username', username, pkURLSEGMENT, []);
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

function Tv2.loginUser(username : string; password : string) : string;
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmGET;
    Request.Accept := 'application/json';
    Request.Resource := '/user/login';
    Request.AddParameter('username', username, pkQUERY, []);
    Request.AddParameter('password', password, pkQUERY, []);
    Request.Execute;
    if Response.StatusCode = 200 then
    begin
      Result := Response.Content;
    end;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.logoutUser;
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmGET;
    Request.Accept := 'application/json';
    Request.Resource := '/user/logout';
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;

procedure Tv2.createUser(body : TUser);
var
  Client   : TRestClient;
  Request  : TRestRequest;
  Response : TRestResponse;
begin
  Client           := TRestClient.Create('https://petstore.swagger.io/v2');
  Request          := TRestRequest.Create(nil);
  Response         := TRestResponse.Create(nil);
  try
    Request.Client   := Client;
    Request.Response := Response;
    Request.HandleRedirects := True;
    Request.Method := rmPOST;
    Request.Accept := 'application/json';
    Request.Resource := '/user';
    Request.AddBody(TJSON.ObjectToJsonObject(body));
    Request.Execute;
  finally
    Client.Free;
    Request.Free;
    Response.Free;
  end;
end;


end.
